#include "FacebookSony.h"
#include "MessagePipe.h"
#include "SignInSony.h"
#include "ErrorCodesSony.h"

using namespace sce::Toolkit::NP;
using namespace sce::Toolkit::NP::Utilities;

namespace UnityPlugin
{
	NpFacebook gFacebook;

	DO_EXPORT( bool, PrxFacebookIsBusy ) ()
	{
		return gFacebook.IsBusy();
	}

	DO_EXPORT( bool, PrxFacebookGetLastError) (ResultCode* result)
	{
		return gFacebook.GetLastError(result);
	}
	
	DO_EXPORT( ErrorCode, PrxFacebookPostMessage ) (PostFacebook* message)
	{
		return gFacebook.PostMessage(message);
	}

	NpFacebook::NpFacebook()
		: m_Busy(false)
		, m_LastResult("NpFacebook")
	{
	}

	bool NpFacebook::ProcessEvent(const sce::Toolkit::NP::Event& event)
	{
		SimpleLock::AutoLock lock(m_Lock);
		bool handled = false;

		switch(event.event)
		{
			case Event::snsMessagePosted:	// An event generated when a message was successfully posted to facebook.
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_FacebookMessagePosted);
				m_Busy = false;
				handled = true;
				break;


			case Event::snsError:			// An event generated when an sns specific error has occurred.
				if(event.returnCode != SCE_TOOLKIT_NP_SUCCESS && event.returnCode != SCE_TOOLKIT_NP_SNS_MESSAGE_POST_FAILED)
				{
					m_LastResult.SetResultSCE(event.returnCode, true, __FUNCTION__, __LINE__);
				}
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_FacebookMessagePostFailed);
				m_Busy = false;
				handled = true;
				break;

			default:
				m_Busy = false;
				handled = true;
				Messages::LogWarning("NpFacebook - Unhandled event %d", event.event);
				break;
		}

		return handled;
	}

	bool NpFacebook::IsBusy()
	{
		SimpleLock::AutoLock lock(m_Lock);
		return m_Busy;
	}

	ErrorCode NpFacebook::SetAppID(UInt64 appID)
	{
		int ret = Sns::Interface::setAppIdFb(appID);
		if(ret != SCE_TOOLKIT_NP_SUCCESS)
		{
			return m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
		}
		
		return NP_OK;
	}

	ErrorCode NpFacebook::PostMessage(PostFacebook* message)
	{
		if(IsBusy())
		{
			return m_LastResult.SetResult(NP_ERR_BUSY, true);
		}
		SimpleLock::AutoLock lock(m_Lock);

		m_LastResult.Reset();

		int ret;
		sce::Toolkit::NP::SnsPostFacebook msgDetails;

		ErrorCode errCode = SetAppID(message->appID);
		if(errCode != NP_OK)
		{
			return errCode;
		}

		if(message->userText) msgDetails.userText = message->userText;
		if(message->photoURL) msgDetails.photo.url = message->photoURL;
		if(message->photoTitle) msgDetails.photo.title = message->photoTitle;
		if(message->photoCaption) msgDetails.photo.caption = message->photoCaption;
		if(message->photoDescription) msgDetails.photo.description = message->photoDescription;
		if(message->actionLinkName) msgDetails.actionLink.name = message->actionLinkName;
		if(message->actionLinkURL) msgDetails.actionLink.url = message->actionLinkURL;

		ret = Sns::Interface::postMessageFb(msgDetails);
		if(ret != SCE_TOOLKIT_NP_SUCCESS)
		{
			return m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
		}

		m_Busy = true;
		return m_LastResult.GetResult();
	}

}
